@extends('layouts.master')

@section('title')
    Check in Staff
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Check in Staff</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-6">
        <div class="box">
             <div class="box-header with-border">
                <h4>Check in</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan" id="table1">
                    <thead>
                         <th style="width: 5%;">No</th>
                        <th>Tanggal/Waktu</th>    
                    </thead>
                </table>   
            </div>
        </div>
    </div>
      <div class="col-lg-6">
        <div class="box">
            <div class="box-header with-border">
                <h4>Check Out</h4>
            </div>
            
            <div class="box-body table-responsive">
                {{-- <form action="" method="post" class="form-produk"> --}}
                    {{-- @csrf --}}
                    <table class="table table-stiped table-bordered" id="table2">
                        <thead>
                            <th style="width: 5%;">No</th>
                            <th>Tanggal</th>
                        </thead>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection
@push('scripts')
<script>
     $(function () {
        table1 = $('#table1').DataTable({
            responsive: true,
            processing: true,
            serverSide: true,
            autoWidth: false,
            searching: false,
            ajax: {
                url: '{{ route('user.data_absen',$user->id) }}',
            },
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                // {data: 'visit'},              
                {data: 'waktu'},             
            ]
        });

        

        

        $('#modal-form').validator().on('submit', function (e) {
            if (! e.preventDefault()) {
                $.post($('#modal-form form').attr('action'), $('#modal-form form').serialize())
                    .done((response) => {
                        $('#modal-form').modal('hide');
                        table1.ajax.reload();
                    })
                    .fail((errors) => {
                        alert('Tidak dapat menyimpan data');
                        return;
                    });
            }
        });
       

        $('[name=select_all]').on('click', function () {
            $(':checkbox').prop('checked', this.checked);
        });
    });
</script>
<script>
   

    $(function () {
        table2 = $('#table2').DataTable({
            responsive: true,
            processing: true,
            serverSide: true,
            autoWidth: false,
            searching:false,
            ajax: {
                url: '{{ route('staff.data_absen',$user->id) }}',
            },
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                // {data: 'visit'},              
                {data: 'waktu'},             
            ]
        });

        

        

        $('#modal-form2').validator().on('submit', function (e) {
            if (! e.preventDefault()) {
                $.post($('#modal-form2 form').attr('action'), $('#modal-form2 form').serialize())
                    .done((response) => {
                        $('#modal-form2').modal('hide');
                        table2.ajax.reload();
                    })
                    .fail((errors) => {
                        alert('Tidak dapat menyimpan data');
                        return;
                    });
            }
        });
       

        $('[name=select_all]').on('click', function () {
            $(':checkbox').prop('checked', this.checked);
        });
    });

    function addForm2(url) {
        $('#modal-form2').modal('show');
        $('#modal-form2 .modal-title').text('Tambah Visit Personal');

        $('#modal-form2 form')[0].reset();
        $('#modal-form2 form').attr('action', url);
        $('#modal-form2 [name=_method]').val('post');
        $('#modal-form2 [name=nama]').focus();
    }

    

  

    
    
</script>
@endpush