<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Nota PDF</title>

    <style>
        table td {
            /* font-family: Arial, Helvetica, sans-serif; */
            font-size: 14px;
        }
        table.data td,
        table.data th {
            border: 1px solid #ccc;
            padding: 5px;
        }
        table.data {
            border-collapse: collapse;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
    </style>
</head>
<body>
    <table width="100%">
        <tr>
            <td rowspan="4" width="50%">
                <img src="img/hds.jpg" width="120">
                <br>
                <!--<?php echo e($setting->alamat); ?>-->
                <br>
                <br>
            </td>
            <td>Tanggal</td>
            <td>:<?php echo e(tanggal_indonesia(date('Y-m-d'))); ?></td>
        </tr>
        <tr>
            <td>Kode Member</td>
            <td>: <?php echo e($penjualan->member->nama ?? ''); ?></td>
        </tr>
    </table>

    <table class="data" width="100%">
        <thead>
            <tr>
                <th>No</th>
                <th>Kode</th>
                <th>Nama</th>
                <th>Harga Satuan</th>
                <th>Jumlah</th>
               
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($key+1); ?></td>
                    <td><?php echo e($item->produk->kode_produk); ?></td>
                    <td><?php echo e($item->produk->nama_produk); ?></td>
                    <td class="text-right"><?php echo e(format_uang($item->harga_jual)); ?></td>
                    <td class="text-right"><?php echo e(format_uang($item->jumlah)); ?></td>
                    
                    <td class="text-right"><?php echo e(format_uang($item->subtotal)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" class="text-right"><b>Total Harga</b></td>
                <td class="text-right"><b><?php echo e(format_uang($penjualan->total_harga)); ?></b></td>
            </tr>
           
            <tr>
                <td colspan="5" class="text-right"><b>Total Bayar</b></td>
                <td class="text-right"><b><?php echo e(format_uang($penjualan->bayar)); ?></b></td>
            </tr>
            
           
        </tfoot>
    </table>

    <table width="100%">
        <tr>
            <td><b>Terimakasih telah berbelanja dan sampai jumpa</b></td>
            <td class="text-center">
                Kasir
                <br>
                <br>
                <?php echo e(auth()->user()->name); ?>

            </td>
        </tr>
    </table>
</body>
</html><?php /**PATH /home/gscc6749/public_html/gscdemo02.xyz/laravel/resources/views/penjualan/nota_besar.blade.php ENDPATH**/ ?>