

<?php $__env->startSection('title'); ?>
    Ganti Kartu Member
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('breadcrumb'); ?>
    <li class="active">Ganti Kartu Member</li>
<?php $__env->stopSection(); ?>
<style>
  :root {
      --primary-color: rgb(11, 78, 179)
  }

  *,
  *::before,
  *::after {
      box-sizing: border-box
  }

  body {
      font-family: Montserrat, "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      margin: 0;
      display: grid;
    
      min-height: 100vh;
      background-color: #0b4eb3
  }

  label {
      display: block;
      margin-bottom: 0.5rem
  }

  input {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }
  select {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }
  textarea {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }

  .width-50 {
      width: 50%
  }

  .ml-auto {
      margin-left: auto
  }

  .text-center {
      text-align: center
  }

  .progressbar {
      position: relative;
      display: flex;
      justify-content: space-between;
      counter-reset: step;
      margin: 2rem 0 4rem
  }

  .progressbar::before,
  .progress {
      content: "";
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      height: 4px;
      width: 100%;
      background-color: #dcdcdc;
      z-index: 1
  }

  .progress {
      background-color: rgb(0 128 0);
      width: 0%;
      transition: 0.3s;
      height:6px ;
  }

  .progress-step {
      width: 2.1875rem;
      height: 2.1875rem;
      background-color: #dcdcdc;
      border-radius: 50%;
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 1
  }

  .progress-step::before {
      counter-increment: step;
      content: counter(step)
  }

  .progress-step::after {
      content: attr(data-title);
      position: absolute;
      top: calc(100% + 0.5rem);
      font-size: 0.85rem;
      color: #666;
  }

  .progress-step-active {
      background-color: var(--primary-color);
      color: #f3f3f3
  }

  .form {
      width: clamp(320px, 30%, 430px);
      margin: 0 auto;
      border: none;
      border-radius: 10px !important;
      overflow: hidden;
      padding: 1.5rem;
      background-color: #fff;
      padding: 20px 30px
  }

  .step-forms {
      display: none;
      transform-origin: top;
      animation: animate 1s
  }

  .step-forms-active {
      display: block
  }

  .group-inputs {
      margin: 1rem 0
  }

  @keyframes  animate {
      from {
          transform: scale(1, 0);
          opacity: 0
      }

      to {
          transform: scale(1, 1);
          opacity: 1
      }
  }

  .btns-group {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 1.5rem
  }

  .btn {
      padding: 0.75rem;
      display: block;
      text-decoration: none;
      background-color: var(--primary-color);
      color: #f3f3f3;
      text-align: center;
      border-radius: 0.25rem;
      cursor: pointer;
      transition: 0.3s
  }

  .btn:hover {
      box-shadow: 0 0 0 2px #fff, 0 0 0 3px var(--primary-color)
  }

  .progress-step-check {
      position: relative;
      background-color: green !important;
      transition: all 0.8s;
      /* height: 4px; */
  }

  .progress-step-check::before {
      position: absolute;
      content: '\2713';
      width: 100%;
      height: 100%;
      top: 3px;
      left: 7px;
      font-size: 12px;
  }

  .group-inputs {
      position: relative
  }

  .group-inputs label {
      font-size: 13px;
      position: absolute;
      height: 19px;
      padding: 4px 7px;
      top: -14px;
      left: 10px;
      color: #a2a2a2;
      background-color: white
  }


  .welcome {
      height: 450px;
      width: 350px;
      background-color: #fff;
      border-radius: 6px;
      display: flex;
      justify-content: center;
      align-items: center
  }

  .welcome .content {
      display: flex;
      align-items: center;
      flex-direction: column
  }

  .checkmark__circle {
      stroke-dasharray: 166;
      stroke-dashoffset: 166;
      stroke-width: 2;
      stroke-miterlimit: 10;
      stroke: #7ac142;
      fill: none;
      animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards
  }

  .checkmark {
      width: 56px;
      height: 56px;
      border-radius: 50%;
      display: block;
      stroke-width: 2;
      stroke: #fff;
      stroke-miterlimit: 10;
      margin: 10% auto;
      box-shadow: inset 0px 0px 0px #7ac142;
      animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both
  }

  .checkmark__check {
      transform-origin: 50% 50%;
      stroke-dasharray: 48;
      stroke-dashoffset: 48;
      animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards
  }

  @keyframes  stroke {
      100% {
          stroke-dashoffset: 0
      }
  }

  @keyframes  scale {

      0%,
      100% {
          transform: none
      }

      50% {
          transform: scale3d(1.1, 1.1, 1)
      }
  }

  @keyframes  fill {
      100% {
          box-shadow: inset 0px 0px 0px 30px #7ac142
      }
  }
</style>
<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('member.updated_profil', $member->id_member)); ?>" class="form" id="forms" style="width:75%;" method="post">
   <?php echo csrf_field(); ?>
  <?php echo method_field('PUT'); ?>
    
    <input type="hidden" class="form-control" id="role" name="role" value=<?php echo e(auth()->user()->name); ?>>
    <input type="hidden" class="form-control" id="tgl_masuk" name="tgl_masuk" value=<?php echo e($date); ?>>
    <input type="hidden" class="form-control" id="status" name="status" value="GANTI KARTU">
    <input type="hidden" class="form-control" id="id_member" name="id_member" value=<?php echo e($member->id_member); ?>>
    <div class="progressbar">
        <div class="progress" id="progress" style="height: 6px; background-color:green;"></div>
        <div class="progress-step progress-step-active" data-title="Profil Anggota"></div>
        <div class="progress-step" data-title="Pembayaran"></div>
    </div>
<div class="step-forms step-forms-active">
    <h2>Profile Member</h2>
    <h4 style="color: black;">*  Wajib di isi</h4>
    <div class="row">
      
      <div class="col-sm-6">
        <div class="group-inputs"> <label for="nama">Nama Lengkap *</label> <input type="text" name="nama" id="nama"  value="<?php echo e(old('nama',$member->nama)); ?>"> </div>
            <?php if($errors->has('nama')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('nama')); ?></span>
            <?php endif; ?>
        </div>
        <div class="col-sm-6">
        <div class="group-inputs"> <label for="nama">Kode Member *</label> <textarea name="kode_member" id="kode_member" ><?php echo e(old('kode_member')); ?></textarea> </div>
            <?php if($errors->has('kode_member')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('kode_member')); ?></span>
            <?php endif; ?>
        </div>
    </div>  


    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="ttl">Tempat Tanggal Lahir *</label> <input type="text" name="ttl" id="ttl"  value="<?php echo e(old('ttl',$member->ttl)); ?>" placeholder="Contoh: Malang 9 September"> </div>
            <?php if($errors->has('ttl')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('ttl')); ?></span>
            <?php endif; ?>
        </div>
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="alamat">Alamat Rumah *</label> <textarea name="alamat" id="alamat"> <?php echo e(old('alamat',$member->alamat)); ?></textarea></div>
            <?php if($errors->has('alamat')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('alamat')); ?></span>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="telepon">Telepon *</label> <input type="text" name="telepon" id="telepon"  value="<?php echo e(old('telepon',$member->telepon)); ?>"> </div>
            <?php if($errors->has('telepon')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('telepon')); ?></span>
            <?php endif; ?>
        </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="telepon_darurat">Telepon Darurat *</label> <input type="text" name="telepon_darurat" id="telepon_darurat"  value="<?php echo e(old('telepon_darurat',$member->telepon_darurat)); ?>"> </div>
             <?php if($errors->has('telepon_darurat')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('telepon_darurat')); ?></span>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="no_ktp">Nomer KTP *</label> <input type="text" name="no_ktp" id="no_ktp"  value="<?php echo e(old('no_ktp',$member->no_ktp)); ?>"> </div>
            <?php if($errors->has('no_ktp')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('no_ktp')); ?></span>
            <?php endif; ?>
        </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="gender">Gender *</label> <select  name="gender" id="gender">
                 <option value="" disabled selected style="color: lightgrey;">Gender</option>
                <option value="L" <?php if(old('gender') == "L"): ?> <?php echo e('selected'); ?> <?php endif; ?> <?php echo e($member->gender == 'L' ? 'selected' : ''); ?>>Laki-Laki</option>
                <option value="P" <?php if(old('gender') == "P"): ?> <?php echo e('selected'); ?> <?php endif; ?> <?php echo e($member->gender == 'P' ? 'selected' : ''); ?>>Perempuan</option>
                </select>
                <?php if($errors->has('gender')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('gender')); ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
              <div class="group-inputs"> <label for="sosmed">Sosmed</label> <input type="text" name="sosmed" id="sosmed"  value="<?php echo e(old('sosmed',$member->sosmed)); ?>"> </div>
         </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="email">Email *</label> <input type="email" name="email" id="email"  value="<?php echo e(old('email', $member->email)); ?>"> </div>
            <?php if($errors->has('email')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('email')); ?></span>
            <?php endif; ?>
        </div>  
    </div>
    <div class="row">
         <div class="col-sm-12">
            <div class="group-inputs"> <label for="alamat_kantor">Alamat Kantor *</label> <textarea name="alamat_kantor" id="alamat_kantor" ><?php echo e(old('alamat_kantor',$member->alamat_kantor)); ?></textarea> </div>
            <?php if($errors->has('alamat_kantor')): ?>
                <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('alamat_kantor')); ?></span>
            <?php endif; ?>
        </div>
    </div>
        <div class="" style="text-align: center;"> <a href="#" class="btn btn-next width-50 ml-auto">Next</a> </div>
    </div>
    <div class="perhitungan">
        <div class="step-forms">
            <h2  style="margin-bottom: 16px;">Pembayaran</h2>
                
            
             <div class="row">
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Harga Ganti Kartu *</label> <input type="text" name="total" id="total"class="hasil" value="<?php echo e(old('hasil')); ?>"> 
                        <?php if($errors->has('total')): ?>
                            <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('total')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                  <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Tanggal Pembayaran *</label> <input type="text" name="tanggal_bayar2" id="tanggal_bayar2" readonly value="<?php echo e($date); ?>" />
                        <?php if($errors->has('tanggal_bayar2')): ?>
                            <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('tanggal_bayar2')); ?></span>
                        <?php endif; ?>
                    </div>
                  </div>
             </div>

              <div class="row" hidden>
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Bayar *</label> <input type="text" name="harus_bayar" id="harus_bayar"class="bil5" value="<?php echo e(old('hasil')); ?>"> 
                        <?php if($errors->has('harus_bayar')): ?>
                            <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('harus_bayar')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                  <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Sisa *</label> <input type="text" name="sisa" id="sisa" class="sisa" readonly />
                        <?php if($errors->has('sisa')): ?>
                            <span class="invalid-feedback" style="color:red;"><?php echo e($errors->first('sisa')); ?></span>
                        <?php endif; ?>
                    </div>
                  </div>
             </div>
             

            

                
             
             
            <div class="btns-group"> 
                <a href="#" class="btn btn-prev">Previous</a> 
                <button type="submit" class="btn btn-info pull-right">Simpan</button></div>
        </div>
    </div>
   
</form>
  <?php $__env->stopSection(); ?>
 
  <?php $__env->startPush('scripts'); ?>

  <script type="text/javascript" src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>
  <script src ="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
  <script >
     $( document ).ready(function() {
              $( ".target" ).change(function() {
                var id = $(this).val();
                // var nama = $(this).find('nama_supplier');
                // console.log(nama);
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('layanan.ambil.data')); ?>',
                    data: {
                        layanan_id: JSON.stringify($('.layanan_id').val())
                    },
                    success: function(response) 
                    {
                        console.log(response);
                        $('.harga').val(response[0].harga);
                        
                    },
                    error: function(response) {
                        alert(response.responseJSON.message);
                    }
                });
              });

                $( ".target2" ).change(function() {
                var id = $(this).val();
                // var nama = $(this).find('nama_supplier');
                // console.log(nama);
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('layanan.ambil.data2')); ?>',
                    data: {
                        iseng: JSON.stringify($('.layanan_id2').val())
                    },
                    success: function(response) 
                    {
                        console.log(response);
                        $('.harga_personal').val(response[0].harga);
                        
                    },
                    error: function(response) {
                        alert(response.responseJSON.message);
                    }
                });
              });


        $(".perhitungan").keyup(function(){
          var bil3 = parseInt($(".bil3").val())
          var bil4 = parseInt($(".bil4").val())
    
          var hasil =  bil3 + bil4;
          if(hasil > 0) {
          $(".hasil").attr("value",hasil)
          }else{
            $(".hasil").attr("value",0)
          }
        });
        const prevBtns = document.querySelectorAll(".btn-prev");
const nextBtns = document.querySelectorAll(".btn-next");
const progress = document.getElementById("progress");
const formSteps = document.querySelectorAll(".step-forms");
const progressSteps = document.querySelectorAll(".progress-step");


let formStepsNum = 0;

nextBtns.forEach((btn) => {
btn.addEventListener("click", () => {
formStepsNum++;
updateFormSteps();
updateProgressbar();

});
});

prevBtns.forEach((btn) => {
btn.addEventListener("click", () => {
formStepsNum--;
updateFormSteps();
updateProgressbar();

});
});

function updateFormSteps() {
formSteps.forEach((formStep) => {
formStep.classList.contains("step-forms-active") &&
formStep.classList.remove("step-forms-active");
});

formSteps[formStepsNum].classList.add("step-forms-active");
}

function updateProgressbar() {
    progressSteps.forEach((progressStep, idx) => {
    if (idx < formStepsNum + 1) { progressStep.classList.add("progress-step-active"); } else { progressStep.classList.remove("progress-step-active"); } }); progressSteps.forEach((progressStep, idx)=> {
        if (idx < formStepsNum) { progressStep.classList.add("progress-step-check"); } else { progressStep.classList.remove("progress-step-check"); } }); const progressActive=document.querySelectorAll(".progress-step-active"); progress.style.width=((progressActive.length - 1) / (progressSteps.length - 1)) * 100 + "%" ; } document.getElementById("submit-form").addEventListener("click", function () { progressSteps.forEach((progressStep, idx)=> {
            if (idx <= formStepsNum) { progressStep.classList.add("progress-step-check"); } else { progressStep.classList.remove("progress-step-check"); } }); var forms=document.getElementById("forms"); forms.classList.remove("form"); forms.innerHTML='<div class="welcome"><div class="content"><svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52"><circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/><path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/></svg><h2>Thanks for signup!</h2><span>We will contact you soon!</span><div></div>' ; });
});
  </script>
  <?php $__env->stopPush(); ?>
 

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gscc6749/public_html/cruuzion.my.id/laravel/resources/views/member/ganti_kartu.blade.php ENDPATH**/ ?>