<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Instruktur;
use App\Models\CheckIns;
use App\Models\Checkout_instruktur;
use Carbon\Carbon;
class InstrukturController extends Controller
{
    public function index()
    {
        // $bulan = date('m');
        //  dd($bulan);
        return view('instruktur.index');
    }

    public function data()
    {
        $instruktur = Instruktur::all();

        return datatables()
            ->of($instruktur)
            ->addIndexColumn()
            ->addColumn('select_all', function ($instruktur) {
                return '
                    <input type="checkbox" name="id_instruktur[]" value="'. $instruktur->id_instruktur .'">
                ';
            })
            ->addColumn('kode_instruktur', function ($instruktur) {
                return '<span class="label label-primary">'. $instruktur->kode_instruktur .'</span>';
            })
            ->addColumn('aksi', function ($instruktur) {
                return '
                <div class="btn-group">
                 <a href="'. route('checkins.absen', $instruktur->id_instruktur) .'" class="btn btn-xs btn-success btn-flat">Absensi</a>
                    <button type="button" onclick="editForm(`'. route('instruktur.update', $instruktur->id_instruktur) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('instruktur.destroy', $instruktur->id_instruktur) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'select_all','kode_instruktur'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    public function absen($id)
    {
        
        $instruktur = Instruktur::find($id);
      
        return view('instruktur.absen', compact('instruktur'));
    }
     public function data_absen($id)
    {

      $instruktur = CheckIns::where('kode_instruktur',$id);
        return datatables()
            ->of($instruktur)
            ->addIndexColumn()
            ->addColumn('select_all', function ($instruktur) {
                return '
                   
                ';
            })
           
            ->addColumn('aksi', function ($instruktur) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    //     $instruktur = Checkins::where('kode_instruktur',$id)->where('waktu','<=', Carbon::now()->format('Y-m-d'))->get();
    //     return datatables()
    //         ->of($instruktur)
    //         ->addIndexColumn()
    //         ->addColumn('select_all', function ($instruktur) {
    //             return '
                   
    //             ';
    //         })
           
    //         ->addColumn('aksi', function ($instruktur) {
    //             return '
               
    //             ';
    //         })
    //         ->rawColumns(['aksi', 'kode_paket', 'select_all'])
    //         ->make(true);
     }

    public function instruktur_data_absen($id)
    {
        // $bulan = time();
        $instruktur2 = Checkout_instruktur::where('kode_instruktur',$id);
            // dd($personal2);
        return datatables()
            ->of($instruktur2)
            ->addIndexColumn()
            ->addColumn('select_all', function ($instruktur2) {
                return '
                   
                ';
            })
           
            ->addColumn('aksi', function ($instruktur2) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all','instruktur2'])
            ->make(true);
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $instruktur = Instruktur::latest()->first() ?? new Instruktur();
        $request['kode_instruktur'] = 'I'. tambah_nol_didepan((int)$instruktur->id_instruktur +1, 6);

        $instruktur = Instruktur::create($request->all());
        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $instruktur = Instruktur::find($id);

        return response()->json($instruktur);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $instruktur = Instruktur::find($id)->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $instruktur = Instruktur::find($id)->delete();

        return response(null, 204);
    }
    public function deleteSelected(Request $request)
    {
        foreach ($request->id_instruktur as $id) {
            $instruktur = Instruktur::find($id);
            $instruktur->delete();
        }

        return response(null, 204);
    }
}
