<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use\App\Models\Paket_personal_trainer;
class PaketPersonalController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $kategori = Kategori::all()->pluck('nama_kategori', 'id_kategori');

        return view('paket_personal.index');
    }

    public function data()
    {
        $paket_personal = Paket_personal_trainer::all();

        return datatables()
            ->of($paket_personal)
            ->addIndexColumn()
            ->addColumn('select_all', function ($paket_personal) {
                return '
                    <input type="checkbox" name="id[]" value="'. $paket_personal->id .'">
                ';
            })
           ->addColumn('kode_paket', function ($paket_personal) {
                return '<span class="label label-primary">'. $paket_personal->kode_paket .'</span>';
            })
            ->addColumn('harga', function ($paket_personal) {
                return 'Rp.'.format_uang($paket_personal->harga);
            })
            ->addColumn('aksi', function ($paket_personal) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('paket_personal.update', $paket_personal->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('paket_personal.destroy', $paket_personal->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $harga = preg_replace('/[^0-9]/', '', $request->get('harga'));
        $paket_id = Paket_personal_trainer::latest()->first() ?? new Paket_personal_trainer();
        
        
        
        $paket = new Paket_personal_trainer();
        $paket->kode_paket = 'PPT'. tambah_nol_didepan((int)$paket_id->id +1,);
        $paket->nama_paket = $request->nama_paket;
        $paket->harga = $harga;
        $paket->save();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $paket_personal = Paket_personal_trainer::find($id);

        return response()->json($paket_personal);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $harga = preg_replace('/[^0-9]/', '', $request->get('harga'));
        $paket = Paket_personal_trainer::find($id);
        $paket->nama_paket = $request->nama_paket;
        $paket->harga= $harga;
        $paket->update();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $paket_personal = Paket_personal_trainer::find($id);
        $paket_personal->delete();

        return response(null, 204);
    }

    public function deleteSelected(Request $request)
    {
        foreach ($request->id as $id) {
            $paket_personal = Paket_personal_trainer::find($id);
            $paket_personal->delete();
        }

        return response(null, 204);
    }

    // public function cetakBarcode(Request $request)
    // {
    //     $dataproduk = array();
    //     foreach ($request->id_produk as $id) {
    //         $produk = Produk::find($id);
    //         $dataproduk[] = $produk;
    //     }

    //     $no  = 1;
    //     $pdf = PDF::loadView('produk.barcode', compact('dataproduk', 'no'));
    //     $pdf->setPaper('a4', 'potrait');
    //     return $pdf->stream('produk.pdf');
    // }
}
